use "${tmp}/Regfile_nafZE", replace

	
	xtset gp year
	
	destring ZE2010, replace
	
	// define sample 
	egen mlabexid = group(mainlabex)
	qui su mlabexid
	replace mlabexid = r(max) + ZE2010 if mi(mlabexid)
	

	reghdfe ln_eng_sbrut E_post11  if NAF_labex_accept == 1 & ZE_labex_accept == 1 , a(ZE2010#year  gp)  cl(mlabexid)	
	bys gp: egen insampeng = max(e(sample))
	keep if insampeng
	 
		
	local row0 = " & Static Coefficient & Pre Trends & Obs. \\"
	
	qui prog_gentable EPHerf1_2005, estimator("reghdfe")  dep(ln_eng_sbrut) fe("gp ape_n#year ZE2010#year") clust(mlabexid) 
	local row1 = "Herfindahl \geq 0.1 & `=string(e(coef), "%9.4f")'`=e(star)' & `=e(pt)'  & `=e(Nobs)' obs \\"
	local row2 = "& (`=string(e(se), "%9.4f")') &  & (`=e(Npairs)' pairs) \\ " 
	qui prog_gentable EPHerf2_2005, estimator("reghdfe")  dep(ln_eng_sbrut) fe("gp ape_n#year ZE2010#year") clust(mlabexid) 
	local row3 = "Herfindahl \geq 0.2 & `=string(e(coef), "%9.4f")'`=e(star)' & `=e(pt)'  & `=e(Nobs)' obs \\"
	local row4 = "& (`=string(e(se), "%9.4f")') &  & (`=e(Npairs)' pairs) \\ " 
	qui prog_gentable EPHerf3_2005, estimator("reghdfe")  dep(ln_eng_sbrut) fe("gp ape_n#year ZE2010#year") clust(mlabexid) 
	local row5 = "Herfindahl \geq 0.3 & `=string(e(coef), "%9.4f")'`=e(star)' & `=e(pt)'  & `=e(Nobs)' obs \\"
	local row6 = "& (`=string(e(se), "%9.4f")') &  & (`=e(Npairs)' pairs) \\ " 
	
	file open myfile using "${outpath}/tableA7.tex", write text replace
	forvalues i = 0/6 {
		file write myfile " `row`i''" _n
	}
	file close myfile